// RWS
implementation module osmenu

import clCrossCall
import ostoolbox
from	oswindow	import OSdestroyWindow,OSactivateWindow,OSWindowPtr	// PA: added


//	Types for menus and menu elements:
::	MenuBar
	=	NoMenuBar
	|	MenuBar OSMenuBar
::	OSMenuBar
	=	{	menuBar		:: !HMENU
		,	menuWindow	:: !HWND	// PA: type of menuWindow perhaps should be OSWindowPtr
		}
::	OSMenuHandle	:== HMENU
::	OSMenu			:== HMENU
::	OSMenuItem		:== HITEM
::	OSMenuSeparator	:== HITEM

//	Dummy values:
OSNoMenu :== 0
OSNoMenuItem :== 0
OSNoMenuSeparator :== 0


//	Enabling and disabling menus and menu elements:

OSDisableMenu :: !Int !OSMenuBar !*OSToolbox -> *OSToolbox
OSDisableMenu zIndex osMenuBar=:{menuBar} tb
	= WinChangeMenuAbility menuBar zIndex False tb

OSEnableMenu :: !Int !OSMenuBar !*OSToolbox -> *OSToolbox
OSEnableMenu zIndex osMenuBar=:{menuBar} tb
	= WinChangeMenuAbility menuBar zIndex True tb

OSEnableMenuItem :: !OSMenu !OSMenuItem !*OSToolbox -> *OSToolbox
OSEnableMenuItem menuHandle item tb
	= WinChangeItemAbility menuHandle item True tb

OSDisableMenuItem :: !OSMenu !OSMenuItem !*OSToolbox -> *OSToolbox
OSDisableMenuItem menuHandle item tb
	= WinChangeItemAbility menuHandle item False tb


//	Changing and updating the menu bar:

OSMenuBarNew :: !*OSToolbox -> (!OSMenuBar,!*OSToolbox)
OSMenuBarNew tb
	# (menuBar,tb)		= WinCreateMenuBarHandle tb
	# (menuWindow,tb)	= WinCreateMenuWindow menuBar "Clean Application" tb
	= ({menuBar=menuBar,menuWindow=menuWindow},tb)

DrawMenuBar :: !*OSToolbox -> *OSToolbox
DrawMenuBar tb
	= WinDrawMenuBar tb

OSMenuBarClear :: !*OSToolbox -> *OSToolbox
OSMenuBarClear tb
	= tb

OSMenuBarSet :: !OSMenuBar !*OSToolbox -> (!OSMenuBar,!*OSToolbox)
OSMenuBarSet menuBar tb
	= (menuBar,tb)

OSMenuBarRemove :: !OSMenuBar !*OSToolbox -> *OSToolbox
OSMenuBarRemove {menuBar,menuWindow} tb
	# (_,_,tb)	= OSdestroyWindow False menuWindow tb
	= tb
	
OSMenuInsert :: !Int !OSMenuNr !{#Char} !OSMenuBar !*OSToolbox -> (!OSMenu,!OSMenuBar,!*OSToolbox)
OSMenuInsert index osMenuNr title menuBar tb
	# (menu,tb) = WinCreatePopupMenuHandle tb
	= (menu,menuBar,WinInsertMenu title True menu menuBar.menuBar index tb)
	
OSSubMenuInsert :: !Int !OSMenuNr !{#Char} !OSMenu !*OSToolbox -> (!OSMenu, !OSMenu, !*OSToolbox)
OSSubMenuInsert index osMenuNr title parentMenu tb
	# (menu,tb) = WinCreatePopupMenuHandle tb
	= (menu,parentMenu,WinInsertMenu title True menu parentMenu index tb)

OSMenuRemove :: !OSMenu !OSMenuBar !*OSToolbox -> (!OSMenuBar, !*OSToolbox)
OSMenuRemove menu menuBar=:{menuBar=hmenu} tb
	# tb	= WinDeleteMenu hmenu menu tb
	# tb	= WinDestroyMenu menu tb
	= (menuBar,tb)

OSSubMenuRemove :: !OSMenu !OSMenu !*OSToolbox -> (!OSMenu,!*OSToolbox)
OSSubMenuRemove submenu hmenu tb
	# tb	= WinDeleteMenu hmenu submenu tb
	# tb	= WinDestroyMenu submenu tb
	= (hmenu,tb)


//	Changing (sub)menus:
OSAppendMenuItem :: !Int !OSMenu !{#Char} !Bool !Bool !Char !*OSToolbox -> (!OSMenuItem,!OSMenu,!*OSToolbox)
OSAppendMenuItem index menu title able mark key tb
	# title		= if (key <> '\0')
					(title +++ "\tCtrl+" +++ toString (toUpper key))
					title
	# (item,tb)	= WinInsertMenuItem title able mark menu index tb
	# tb		= Iprint (toString item +++ " <- create menu item\n") tb
	| key <> '\0'
		= (item,menu,WinSetShortcut item key tb)
	// otherwise
		= (item,menu,tb)

OSAppendMenuSeparator :: !Int !OSMenu !*OSToolbox -> (!OSMenuSeparator,!OSMenu,!*OSToolbox)
OSAppendMenuSeparator index menu tb
	# tb	= WinInsertSeparator menu index tb
	= (OSNoMenuSeparator,menu,Iprint ("create menu separator\n") tb)

OSChangeMenuTitle :: !OSMenuBar !OSMenu !{#Char} !*OSToolbox -> *OSToolbox
OSChangeMenuTitle {menuBar} menu title tb
	= WinModifyMenu title menu menuBar tb

OSChangeMenuItemTitle :: !OSMenu !OSMenuItem !{#Char} !*OSToolbox -> *OSToolbox
OSChangeMenuItemTitle menu item title tb
	= WinModifyMenuItem title item menu tb	// RWS +++ don't change able&mark; PA: done

OSMenuItemCheck :: !Bool !OSMenu !OSMenuItem !*OSToolbox -> *OSToolbox
OSMenuItemCheck check menu item tb
	# tb	= WinChangeMenuItemCheck menu item check tb
	= Iprint "change menu item mark\n" tb

OSMenuRemoveItem :: !OSMenuItem !OSMenu !*OSToolbox -> (!OSMenu,!*OSToolbox)
OSMenuRemoveItem item menu tb
	= (menu,WinRemoveMenuItem menu item tb)


//	Validation of (sub)menu (element) attributes:

// OSValidateMenuItemTitle :: !{#Char} -> !{#Char}
OSValidateMenuItemTitle title :== title


//	PA: two new functions that generate free OS ids for menus and sub menus.
//	If the functions fail, then the Bool result is False, and the Int result is 0. Do not continue to create the (sub)menu.
::	OSMenuNr	:== Int
::	OSSubMenuNr	:== Int

OSNewMenuNr :: !*OSToolbox -> (!Bool,!OSMenuNr,!*OSToolbox)
OSNewMenuNr tb
	= (True,0,tb)

OSNewSubMenuNr :: !*OSToolbox -> (!Bool,!OSSubMenuNr,!*OSToolbox)
OSNewSubMenuNr tb
	= (True,0,tb)


//	PA: The following definitions do not seem to be used.
// RWS +++ match with: (menu, itemnr, ositem)
// OSMatchMenuItem :: !Int !OSMenuItem -> Bool
OSMatchMenuItem i v
	:==	i == v

InsertMenu :: !OSMenu !Int !*OSToolbox -> *OSToolbox
InsertMenu menuHandle position tb
	= tb

OSAppendSubmenu :: !Int !OSMenu !{#Char} !*OSToolbox -> (!OSMenu, !*OSToolbox)
OSAppendSubmenu id menu title toolbox
	# (submenu, toolbox)
		=	Iprint (toString id +++ " <- OSAppendSubmenu\n") WinCreatePopupMenuHandle toolbox
	=	(menu, WinAppendMenu title True submenu menu toolbox)

DisposeMenu :: !OSMenu !*OSToolbox -> *OSToolbox
DisposeMenu _ _
	=	abort "DisposeMenu unimplemented\n"

ClearMenuBar :: !*OSToolbox -> *OSToolbox
ClearMenuBar toolbox
	=	toolbox // abort "ClearMenuBar unimplemented\n"
